 ; Ŀ
 ;   MMI - mirror stuff, rejustify text.                                   
 ;   Copyright 2007 by Rocket Software Ltd.                                
 ;   Birds don't lean.                                                     
 ; 

 ; Ŀ
 ;   Bleft - left rejustify a text entity.                                 
 ; 
 (DEFUN BLEFT (enam / entt typ)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (if (= typ "ATTDEF")
      (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
      (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
  (if (assoc 72 entt)
      (setq entt (subst (cons 72 0) (assoc 72 entt) entt))
      (setq entt (append entt (list (cons 72 0)))))
  (entmod entt)
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Bleft end.                                                            
 ; 

 ; Ŀ
 ;   Justx - returns a string describing the justification of the text     
 ;   entity whose data was passed as its sole argument.                    
 ; 
 (DEFUN JUSTX (entt / xjust yjust xjst yjst justrg)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "TEXT")
      (setq yjust (cdr (assoc 73 entt)))
      (setq yjust (cdr (assoc 74 entt))))
 ; Ŀ
 ;   Vertical justification.                                               
 ; 
  (cond ((= yjust 0) (setq yjst ""))       ; base = normal
        ((= yjust 1) (setq yjst "B"))      ; bottom
        ((= yjust 2) (setq yjst "M"))      ; middle
        ((= yjust 3) (setq yjst "T"))      ; top
        (T           (setq yjst "")))      ; default
 ; Ŀ
 ;   Horizontal justification.                                             
 ; 
  (cond ((= xjust 0) (setq xjst "L"))      ; left
        ((= xjust 1) (setq xjst "C"))      ; centre
        ((= xjust 2) (setq xjst "R"))      ; right
        ((= xjust 3) (setq xjst "A"))      ; aligned
        ((= xjust 4) (setq xjst "M"))      ; middle
        ((= xjust 5) (setq xjst "F"))      ; fit
        (T           (setq xjst "L")))     ; default
  (setq justrg (strcat yjst xjst)))
 ; Ŀ
 ;   Justx end.                                                            
 ; 

 ; Ŀ
 ;   Midd - middle rejustify a text entity, preserve the location.         
 ; 
 (DEFUN MIDD (enam / entt ten eleven new10 dist angl new11 nu11)
  (setq entt (entget enam))
  (setq ten (cdr (assoc 10 entt)))
  (setq eleven (cdr (assoc 11 entt)))
  (if (assoc 72 entt)
      (setq entt (subst (cons 72 4) (assoc 72 entt) entt))
      (setq entt (append entt (list (cons 72 4)))))
  (entmod entt)                                        ; change
  (setq entt (entget enam))                            ; get the changed edata
  (setq new10 (cdr (assoc 10 entt)))                   ; new 10 point
  (setq dist (distance ten new10))                     ; distance moved
  (setq angl (angle new10 ten))                        ; and angle
  (setq new11 (cdr (assoc 11 entt)))                   ; new centre point
  (setq nu11 (polar new11 angl dist))             ; move centre same as 10 was
  (entmod (subst (cons 11 nu11) (assoc 11 entt) entt))
 (princ))
 ; Ŀ
 ;   Midd end.                                                             
 ; 

 ; Ŀ
 ;   MLrj - middle left rejustify a text or attdef entity, preserve the    
 ;   location.                                                             
 ; 
 (DEFUN MLRJ (enam / entt typ pta pta1 p11 xdis ydis new11)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (setq pta (cdr (assoc 10 entt)))
  (if (= typ "TEXT")
      (if (assoc 73 entt)
          (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
          (setq entt (append entt (list (cons 73 2)))))
      (if (assoc 74 entt)
          (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
          (setq entt (append entt (list (cons 74 2))))))
  (if (assoc 72 entt)
      (setq entt (subst (cons 72 0) (assoc 72 entt) entt))
      (setq entt (append entt (list (cons 72 0)))))
  (entmod entt)
  (setq entt (entget enam))
  (setq pta1 (cdr (assoc 10 entt)))
  (setq p11 (cdr (assoc 11 entt)))
  (setq xdis (- (car pta) (car pta1)))
  (setq ydis (- (cadr pta) (cadr pta1)))
  (setq new11 (list (+ (car p11) xdis) (+ (cadr p11) ydis) (caddr p11)))
  (entmod (subst (cons 11 new11) (assoc 11 entt) entt))
 (princ))
 ; Ŀ
 ;   MLrj end.                                                             
 ; 

 ; Ŀ
 ;   Mrrj - middle right rejustify a text or attdef entity, preserve the   
 ;   location.                                                             
 ; 
 (DEFUN MRRJ (enam / entt typ pta pta1 p11 xdis ydis new11)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (setq pta (cdr (assoc 10 entt)))
  (if (= typ "TEXT")
      (if (assoc 73 entt)
          (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
          (setq entt (append entt (list (cons 73 2)))))
      (if (assoc 74 entt)
          (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
          (setq entt (append entt (list (cons 74 2))))))
  (if (assoc 72 entt)
      (setq entt (subst (cons 72 2) (assoc 72 entt) entt))
      (setq entt (append entt (list (cons 72 2)))))
  (entmod entt)
  (setq entt (entget enam))
  (setq pta1 (cdr (assoc 10 entt)))
  (setq p11 (cdr (assoc 11 entt)))
  (setq xdis (- (car pta) (car pta1)))
  (setq ydis (- (cadr pta) (cadr pta1)))
  (setq new11 (list (+ (car p11) xdis) (+ (cadr p11) ydis) (caddr p11)))
  (entmod (subst (cons 11 new11) (assoc 11 entt) entt))
 (princ))
 ; Ŀ
 ;   Mrrj end.                                                             
 ; 

 ; Ŀ
 ;   Prang - make sure that an angle is between 0 and 2 x pi.              
 ;   Argument: Angg, and angle in radians.                                 
 ;   Returns an angle in radians between 0 and 2Pi.                        
 ; 
 (DEFUN PRANG (angg)
;  (if (equal angg (* 2 pi) 0.0001)       ; apparently not required
;      (setq angg 0))
  (setq angg (rem angg (* pi 2)))
  (if (< angg 0)
      (setq angg (+ angg (* pi 2))))
 angg)
 ; Ŀ
 ;   Prang end.                                                            
 ; 

 ; Ŀ
 ;   Rite - right rejustify a text entity, preserve the location.          
 ; 
 (DEFUN RITE (enam / entt typ ten0 ten1)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (setq ten0 (cdr (assoc 10 entt)))
  (if (= typ "ATTDEF")
      (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
      (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
  (if (assoc 72 entt)
      (setq entt (subst (cons 72 2) (assoc 72 entt) entt))
      (setq entt (append entt (list (cons 72 2)))))
  (entmod entt)
  (setq entt (entget enam))
  (setq ten1 (cdr (assoc 10 entt)))
  (command "move" enam "" ten1 ten0)
 (princ))
 ; Ŀ
 ;   Rite end.                                                             
 ; 

 ; Ŀ
 ;   Mmi.                                                                  
 ; 
 (DEFUN C:MMI (/ snapp *error* ss pa pb lang insp num enam entt merang just)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk /)
   (setvar "snapmode" snapp)
   (command "undo" "end")
   (print shk)
  (princ))
 ; Ŀ
 ;   Ask for some stuff to mirror.                                         
 ; 
  (write-line "Select entities to mmirror: ")
  (setq ss (ssget))
  (setvar "snapmode" snapp)
 ; Ŀ
 ;   Get a mirror line.                                                    
 ; 
  (setq pa (getpoint "First mirror line point: "))
  (setq pb (getpoint pa "\nSecond point: "))
  (setq lang (angle pa pb))
  (setq lang (prang lang))
 ; Ŀ
 ;   Ask whether to erase individual entities.                             
 ; 
  (initget 0 "Yes No")
  (Setq insp (getkword "\nErase original entities? <N>: "))
  (if (null insp) (setq insp "No"))
 ; Ŀ
 ;   Now process the entities.                                             
 ;   Collect information before modifying the entity.                      
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
 ; Ŀ
 ;   Get and process the text angle.  A text angle may be >= 2Pi or < 0.   
 ;   Of course this may not be text, so it may not have an angle.          
 ; 
         (if (setq merang (cdr (assoc 50 entt)))
             (setq merang (prang merang)))
 ; Ŀ
 ;   Mirror the entity.                                                    
 ; 
         (command "mirror" enam "" pa pb insp)
 ; Ŀ
 ;   Rotate (at least in some idealized sense) the mirror line back to 0.  
 ;   Then do the same with each text entity angle, which should make       
 ;   comparing the two angles less convoluted.                             
 ; 
         (if merang (setq merang (prang (- merang lang))))
 ; Ŀ
 ;   Now post-process the entity: If it is text and was angled within      
 ;   45 degrees of being at a right angle to the mirror line then          
 ;   rejustify it.  Note that the diagram for this is symmetrical if       
 ;   rotated 180 degrees so the endpoints of the mirror line can be        
 ;   selected in either order.                                             
 ; 
         (if (and (member (cdr (assoc 0 entt)) '("TEXT" "ATTDEF"))
                  (or (and (>= merang (* pi 0.25))
                           (<= merang (* pi 0.75)))
                      (and (>= merang (* pi 1.25))
                           (<= merang (* pi 1.75)))))
             (progn
                  (setq just (justx entt))
 ; Ŀ
 ;   If insp is No then the mirrored entities are new, so it is entlast    
 ;   that needs to be rejustified.                                         
 ; 
                  (if (= insp "No") (setq enam (entlast)))
                  (cond ((= just "ML")
                         (mrrj enam))
                        ((member just '("L" "BL"))  ; kludge
                         (rite enam))
                        ((= just "MR")
                         (mlrj enam))
                        ((member just '("R" "MR"))
                         (bleft enam))))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (command "undo" "end")
 (princ))